// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import SwiftUI

struct SwiftUISampleView: View {
    @Binding private var isPresented: Bool
    @Binding private var scanResult: ScanResult?
    
    @ObservedObject private var viewModel: SwiftUISampleViewModel
    
    init(isPresented: Binding<Bool>, scanResult: Binding<ScanResult?>, viewModel: SwiftUISampleViewModel) {
        self._isPresented = isPresented
        self._scanResult = scanResult
        self.viewModel = viewModel
    }
    
    var body: some View {
        ZStack {
            GradientView()
            
            CrosshairView()
            
            VStack {
                HeaderView(error: $viewModel.error) {
                    closeButtonAction()
                }
                
                Spacer()
                
                FooterView()
            }
        }
        .background(CameraFrameView(image: viewModel.frame))
        .onReceive(viewModel.$scanResult, perform: { result in
            guard let result else { return }
            scanResult = result
            isPresented = false
        })
        .onAppear {
            viewModel.startSession()
        }
        .onDisappear {
            viewModel.stopSession()
        }
    }
    
    func closeButtonAction() {
        scanResult = .cancelled
        isPresented = false
    }
}

struct SwiftUISampleView_Previews: PreviewProvider {
    static var previews: some View {
        SwiftUISampleView(isPresented: .constant(true),
                          scanResult: .constant(nil),
                          viewModel: .init())
    }
}
